import os
import sys
import subprocess
import datetime
import imagehash
from PIL import Image
from PIL.ExifTags import TAGS




def FormatDatetime(datetime):
	if 'T' in datetime:
		strs	= datetime.split('T')
	else:
		strs	= datetime.split(' ')
	strdt	= strs[0]
	strtm	= strs[1]

	if ':' in strdt:
		strs	= strdt.split(':')
	else:
		strs	= strdt.split('-')
	str	= strs[0] + '/' + strs[1] + '/' + strs[2]

	if ':' in strtm:
		strs	= strtm.split(':')
	str	= str + '_' + strs[0] + ':' + strs[1] + ':' + strs[2]

#	print('FormatDatetime=' + datetime + ' -> ' + str)
	return str



def GetExifDate_Image(file):
	try:
		img = Image.open(file)
	except:
		return False, 'EXCEPTION(ImageOpen)'

	try:
		exif = img._getexif()
	except:
		return False, 'EXCEPTION(GetExif)'
	try:
		for id,val in exif.items():
			tg = TAGS.get(id, id)
			if tg == 'DateTimeOriginal':
				img.close()	
				fmtval = FormatDatetime(val)
				return True, fmtval
	except AttributeError:
		return False, 'EXCEPTION(Attribute)'

	img.close()	
	return False, 'ExifNotFound'



def GetExifDate_Mov(file):
	ffprob_prm	= ['E:\\Work\\program\\ffmpeg\\ffprobe.exe', '-show_chapters', '-hide_banner', file]
	proc		= subprocess.run(ffprob_prm, stdout = subprocess.PIPE, stderr = subprocess.PIPE)
	response	= proc.stdout.decode('utf8') + '\n' + (proc.stderr.decode('utf8'))
	for line in response.splitlines():
		if 'apple.quicktime.creationdate' in line:
			str		= line.replace('com.apple.quicktime.creationdate:', '')
			str		= str.strip()
			str		= str.replace('+0900', '')
			fmtval	= FormatDatetime(str)
			return True, fmtval
	return False, 'ExifNotFound'



def IsContentsSame(src_file, dst_file):
	src_base, src_ext = os.path.splitext(src_file)
	src_ext	= src_ext.upper()
	if src_ext == '.MOV':
		val_src	= os.path.getsize(src_file)
		val_dst	= os.path.getsize(dst_file)
	else:
		val_src = imagehash.average_hash(Image.open(src_file))
		val_dst = imagehash.average_hash(Image.open(dst_file))

	if val_src == val_dst:
		return True
	else:
		return False



