# coding: UTF-8
import io
import re
import os
import sys
import subprocess
import traceback
from pytz import timezone
import datetime

print('imported Common.py')




def GetRunPath():
	run_path = os.getcwd() + '/'
#	run_path = 'E:/Work/ReSkill/1_SoftwareLanguage/Python/'		# DEBUG
	return run_path



def ReadLinesExCr(file, enc='utf-8'):
	with open(file, 'r', encoding=enc) as fh:
		lines = fh.readlines()
	fh.close()
	for pos in range(len(lines)):
		lines[pos] = lines[pos].replace('\n', '')
	return lines



def MakeFolderIfNotExist(folder):
	if False == os.path.exists(folder):
		os.mkdir(folder)



s_print_on = False
def LogSetPrint(print_on):
	s_print_on = print_on



s_logs = []
def Log(str, print_on=False):
	s_logs.append(str)
	if print_on:
		print(str)



def LogSave(file):
	fh = io.open(file, 'w', encoding='cp932')
	for log in s_logs:
		fh.write(log + u'\n')
	fh.close()


s_cache_file = {}
def ReadFile_WithCache(file):
	key = re.sub('[:,/,\.]','_', file)
	if key in s_cache_file:
		Log('Cache exists=' + key)
	else:
		Log('Reading file=' + file, True)
		with io.open(file, 'r', encoding='cp932') as fh:
			lines = fh.readlines()
			lines = TrimLines(lines)
			fh.close()
			s_cache_file[key] = lines
	return s_cache_file[key]



def ReadFile_Decode(file):
	fh = io.open(file, 'r')
	lines = []
	exist = True
	while exist:
		try:
			line = fh.readline()
			if line == '':
				exist = False
		except UnicodeDecodeError:
			line = 'SKIP'
		lines.append(line)
#		print('line=' + line)
	fh.close()
	return lines



def WriteLines2File(file, lines):
	fh_out = io.open(file, 'w', encoding='cp932')
	for line in lines:
		fh_out.write(line + '\n')



def PrintAndExit(str):
	print (str)
	Log(str)
	jst_now = datetime.datetime.now(timezone('Asia/Tokyo'))
	str_jst = jst_now.strftime('%Y%m%d_%H%M%S')
	LogSave(GetRunPath() + 'PrintAndExit_' + str_jst + '.txt')
	input('PrintAndExit')
	sys.exit()



def WriteAndPrint(line, fh):
	fh.write(line + '\n')
	print (line)



def GetCurrentTimeStr():
	jst_now = datetime.datetime.now(timezone('Asia/Tokyo'))
	str_jst = jst_now.strftime('%Y%m%d_%H%M%S')
	return str_jst



def OpenWithExcel(file):
	excels = [
		'C:\\Program Files (x86)\\Microsoft Office\\root\\Office16\\EXCEL.EXE',
		'C:\\Program Files (x86)\\Microsoft Office\\Office14\\EXCEL.EXE',
	]
	for excel in excels:
		if os.path.isfile(excel):
			subprocess.Popen(excel + ' ' + file)



def TrimLines(lines):
	lines_new = []
	for line in lines:
		if not re.match('^#', line):
			line = re.sub('\n', '', line)
			if not re.match('^\s*\Z', line):
				lines_new.append(line)
	return lines_new



def SubStrBetween(str, start, end):
	retstr	= str
	if start != '':
		pos	= retstr.find(start)
		if pos == -1:
			return ''
		retstr	= retstr[pos + len(start):]

	if end != '':
		pos	= retstr.find(end)
		if pos == -1:
			return ''
		retstr	= retstr[0: pos]

	return retstr



def Debug():
	str = SubStrBetween('AABBCCDDEEFFGG', 'BB', 'EE')
	print(str)



if __name__ == '__main__':
	Debug()



