import sys
sys.path.append('../Common')
import Common
import PhotoCommon
import webbrowser
import numpy as np



#	https://qiita.com/damyarou/items/9cb633e844c78307134a
def CalcDist(lat, long, mylat, mylong):
	ra			= 6378.140														# equatorial radius (km)
	rb			= 6356.755														# polar radius (km)
	F			= (ra - rb) / ra												# flattening of the earth
	rad_lat_a	= np.radians(float(lat))
	rad_lon_a	= np.radians(float(long))
	rad_lat_b	= np.radians(float(mylat))
	rad_lon_b	= np.radians(float(mylong))
	pa			= np.arctan(rb / ra * np.tan(rad_lat_a))
	pb			= np.arctan(rb / ra * np.tan(rad_lat_b))
	xx			= np.arccos(np.sin(pa) * np.sin(pb) + np.cos(pa) * np.cos(pb) * np.cos(rad_lon_a - rad_lon_b))
	c1			= (np.sin(xx) - xx) * (np.sin(pa) + np.sin(pb)) ** 2 / np.cos(xx / 2) ** 2
	c2			= (np.sin(xx) + xx) * (np.sin(pa) - np.sin(pb)) ** 2 / np.sin(xx / 2) ** 2
	dr			= F / 8 * (c1 - c2)
	rho			= ra * (xx + dr)
	print('distance=', rho)
	return rho



def DecideZoomLevel(dist):
#	zoom	ChromeでGooglemap表示して、左右距離測定した結果
#	--------------------------
#	4		9800
#	5		5700
#	6		2800
#	7		1480
#	8		730
#	9		370
#	10		180
#	11		90
#	12		46
#	13		23
#	14		11.5
#	15		5.6
	needdist	= dist * 3
	zarray		= [5.6, 11.5, 23, 46, 90, 180, 370, 730, 1480, 2800, 5700, 9800]
	for zpos in range(len(zarray)):
		if needdist < zarray[zpos]:
			return 15 - zpos
	
	return 3



def OpenMap(file, mylat, mylong):
	result, lat, long = PhotoCommon.GetExif_ImageLatLong(file)
	print('lat,long=', lat, long)
	if result == False:
		print('緯度経度無効')
		input()
		return
	dist	= CalcDist(lat, long, mylat, mylong)
	zlevel	= DecideZoomLevel(dist)
	#	http://imakoko.didit.jp/imakoko_html/memo/parameters_google.html
	url		= 'http://maps.google.co.jp/maps?q=' + str(lat) + ',' + str(long)
	url		= url + '&ll=' + str(lat) + ',' + str(long) + '&z=' + str(zlevel)
	#	https://qiita.com/hideshis/items/1f556847784434cd815e
	webbrowser.open(url)



def Main():
	file	= 'Dummy'
	mylat	= -1
	mylong	= -1
	print('len(sys.argv) == ', len(sys.argv))
	if 4 <= len(sys.argv):
		file	= sys.argv[1]
		mylat	= sys.argv[2]
		mylong	= sys.argv[3]
	OpenMap(file, mylat, mylong)



if __name__ == '__main__':
	Main()



