import os
import sys
import datetime
import re
import shutil
sys.path.append('../Common')
import Common
import PhotoCommon




s_testmode			= True
s_skip_donefiles	= True
def TrimDatetimeStr_YM(strdttm):
	strs	= strdttm.split('_')
	strdt	= strs[0]
	strtm	= strs[1]

	strsdt	= strdt.split('/')
	strstm	= strtm .split(':')
	str	= strsdt[0] + strsdt[1]
#	print('TrimDatetimeStr_YM=' + strdttm + ' -> ' + str)
	return str



def TrimDatetimeStr_YMDHMS(strdttm):
	strs	= strdttm.split('_')
	strdt	= strs[0]
	strtm	= strs[1]

	strsdt	= strdt.split('/')
	strstm	= strtm.split(':')
	str	= strsdt[0] + strsdt[1] + strsdt[2] + '_' + strstm[0] + strstm[1] + strstm[2]
#	print('TrimDatetimeStr_YMDHMS=' + strdttm + ' -> ' + str)
	return str



def GetDateTime(file):
	base, fileext = os.path.splitext(file)
	fileext	= fileext.upper()
	if fileext == '.AAE':
		return 'DATE_NONE', 'FileIsAAE', 'NoDate'

	sucess, exifdate = PhotoCommon.GetExif_ImageShotDate(file)
	if sucess == False:
		return 'DATE_NONE', exifdate, 'NoDate'

	strdt	= TrimDatetimeStr_YM(exifdate)
	strtm	= TrimDatetimeStr_YMDHMS(exifdate);
	if fileext == '.MOV':
		prefix = 'Movie_'
	else:
		prefix = 'Photo_'
	return 'DATE_SHOT', strdt, prefix + strtm + fileext



def WriteLog(path, str):
	fh = open(path, 'a', encoding='utf-8')
	fh.write(str + '\n')
	fh.close()
	print(str)



def IsSkipDoneFile(src_file):
	global s_skip_donefiles
	if not s_skip_donefiles:
		return False
	src_fname	= os.path.basename(src_file)
	if src_fname.startswith('Photo_') or src_fname.startswith('Movie_'):
		return True
	else:
		return False



def Move(src_file, dst_file, log_file, logtype, count):
	global s_testmode
	strlog	= '[Move][' + str(count) + '][' + logtype + '] ' + src_file + ' => ' + dst_file
	WriteLog(log_file, strlog)
	dst_path	= os.path.dirname(dst_file)
	if s_testmode == False:
		Common.MakeFolderIfNotExist(dst_path)
		shutil.move(src_file, dst_file)
#	print(src_file, ' -> ', dst_file)



def Move_WithInc(src_file, dst_file, log_file, count):
	dst_base, dst_ext = os.path.splitext(dst_file)
	for i in range(2, 100):
		dst_file = dst_base + '_' + str(i) + dst_ext
		if not os.path.exists(dst_file):
			Move(src_file, dst_file, log_file, 'Increment', count)
			return True

	return False



def Copy1File(src_file, dst_path, count):
	file_log	= dst_path + '\\Log.txt'
	if IsSkipDoneFile(src_file):
		WriteLog(file_log, '[NOT Copy] Src is done file ' + src_file)
		return

	result, strdate, dst_fname	= GetDateTime(src_file)
	log_file	= dst_path + '\\Log.txt'
	dst_file	= dst_path + '\\' + strdate + '\\' + dst_fname
	dst_path	= os.path.dirname(src_file)

	if result == 'DATE_NONE':
		print('[NOT Copy] ' + strdate + ' ' + src_file)
	elif not os.path.exists(dst_file):
		Move(src_file, dst_file, log_file, 'Normal', count)
	elif PhotoCommon.IsContentsSame(src_file, dst_file):
		WriteLog(file_log, '[NOT Copy] Same Contents Exist ' + src_file + ' <=> ' + dst_file)
	else:
		result = Move_WithInc(src_file, dst_file, log_file, count)
		if not result:
			WriteLog(file_log, '[NOT Copy] over 100! ' + src_file + ' => ' + dst_file)



def PhotoCopy_1Folder(src_path, dst_path):
	print('PhotoCopy_1Folder src_path=' + src_path)
	files	= os.listdir(src_path)
	count	= 1
	now		= datetime.datetime.now()
	file_log	= dst_path + '\\Log.txt'
	WriteLog(file_log, '\n--- Start [{0:%Y/%m/%d %H:%M}] ---'.format(now))
	for fname in files:
		src_file	= src_path + '\\' + fname
		Copy1File(src_file, dst_path, count)
		count=count+1
		if 10000 < count:
			print(count, ' <= count')
			break;



def PhotoCopy():
	global s_testmode
	global s_skip_donefiles
	dst_path	= sys.argv[1]
	src_path	= sys.argv[2]
	if sys.argv[3] == 'False':
		s_testmode	= False
	print('s_testmode = ', s_testmode)
	if sys.argv[4] == 'False':
		s_skip_donefiles	= False
	print('s_skip_donefiles = ', s_skip_donefiles)
	PhotoCopy_1Folder(src_path, dst_path)



def PhotoCopy_Folders():
	dst_path	= sys.argv[1]
	src_top		= dst_path
	dirs		= os.listdir(src_top)
	for dir in dirs:
		pattern = '\d{6}'
		result = re.match(pattern, dir)
		if result:
			inp	= input('Proces ? ' + dir)
			print(inp)
			if inp == 'y':
				PhotoCopy_1Folder(src_top + '\\' + dir, dst_path)



#PhotoCopy_Folders()
PhotoCopy()



